local STRINGS = GLOBAL.STRINGS
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
GetPlayer = GLOBAL.GetPlayer

PrefabFiles = {
	"caitlin",
	"hat_paranoid",
	"hat_disorganized",
	"hat_psychotic",
	"schizo_friend",
	"shadowfriend",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/caitlin.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/caitlin.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/caitlin.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/caitlin.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/caitlin_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/caitlin_silho.xml" ),

    Asset( "IMAGE", "bigportraits/caitlin.tex" ),
    Asset( "ATLAS", "bigportraits/caitlin.xml" ),
	
	Asset( "IMAGE", "images/map_icons/caitlin.tex" ),
	Asset( "ATLAS", "images/map_icons/caitlin.xml" ),

}

local require = GLOBAL.require

local function ModMaxwellIntro(inst)
    if GLOBAL.GetPlayer().prefab == "caitlin" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
            appearsound = "dontstarve/maxwell/appear_adventure",
	    voice = "dontstarve/maxwell/talk_LP_world5",
		appearanim = "appear5",
		idleanim= "idle5_loop",
		dialogpreanim = "dialog5_pre",
		dialoganim="dialog5_loop",
		dialogpostanim = "dialog5_pst",
		disappearanim = "disappear5",
		disableplayer = true,
		skippable = true,
            {
                string = "No, no, this can't be right.",
                wait = 2,
                anim = nil,
                sound = nil,
            },
            {
                string = "Something must have gone wrong. Have I made a mistake?",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "Or was it something you did?",
                wait = 2,
                anim = nil,
                sound = nil,
            },
            {
                string = "Something about you is agitating Them. I've never seen Them act this way before.",
                wait = 4,
                anim = nil,
                sound = nil,
            },
			{
                string = "...whatever it is, you best not let it go to your head.",
                wait = 3,
                anim = nil,
                sound = nil,
			},
			{
                string = "You're tampering with forces infinitely your greater.",
                wait = 3,
                anim = nil,
                sound = nil,
            },
	}
    end
end

AddPrefabPostInit("maxwellintro", ModMaxwellIntro)

GLOBAL.STRINGS.CHARACTER_TITLES.caitlin = "The Ophelia"
GLOBAL.STRINGS.CHARACTER_NAMES.caitlin = "Caitlin"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.caitlin = "*Has a fragile mind.\n*Takes many forms.\n*Frequently hallucinates."
GLOBAL.STRINGS.CHARACTER_QUOTES.caitlin = "\"...is someone there?\""

table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "caitlin")

AddMinimapAtlas("images/map_icons/caitlin.xml")
AddModCharacter("caitlin")

GLOBAL.STRINGS.NAMES.HAT_PARANOID = "Doctored Mask"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_PARANOID = "I don't like wearing this one. It makes me all angry."

GLOBAL.STRINGS.NAMES.HAT_DISORGANIZED = "Malignant Crown"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_DISORGANZIED = "My thoughts become messy with this on..."

GLOBAL.STRINGS.NAMES.HAT_PSYCHOTIC = "Memento"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_PSYCHOTIC = "I don't remember who gave me this..."

GLOBAL.STRINGS.NAMES.SCHIZO_FRIEND = "Hallucination"
GLOBAL.STRINGS.NAMES.CRAWLINGBUDDY = "Hallucination"
GLOBAL.STRINGS.NAMES.TERRORFRIEND = "Hallucination"


local function ModNightmareFuel(inst)
	if GLOBAL.GetPlayer().prefab == "caitlin" then 
		if not inst.components.edible then
			inst:AddComponent("edible") 
		end
		inst:AddTag("scaryfood")
		inst.components.edible.healthvalue = 5
		inst.components.edible.sanityvalue = 12.5
		inst.components.edible.hungervalue = 5
	end
end

AddPrefabPostInit("nightmarefuel", ModNightmareFuel)


function sanitymonsterspawnerpostinit(inst)

	inst.UpdateMonsters = function(self, dt)
	local sanity = self.inst.components.sanity:GetPercent()

	if self.popchangetimer and self.popchangetimer > 0 then
		self.popchangetimer = self.popchangetimer - dt
	elseif self.inst.components.sanity.inducedinsanity then
		self.popchangetimer = 5
		local maxpop = 5
		local inc_chance = 0.7
		local dec_chance = 0.4

		--figure out our new target
		if self.currenttargetpop > maxpop then
			self.currenttargetpop = self.currenttargetpop - 1
		else
			if inc_chance > 0 and math.random() < inc_chance then
				self.currenttargetpop = self.currenttargetpop + 1
			elseif dec_chance > 0 and math.random() < dec_chance then
				self.currenttargetpop = self.currenttargetpop - 1
			end
		end
	else
		self.popchangetimer = 10 + math.random()*10
		
		local maxpop = 0
		local inc_chance = 0
		local dec_chance = 0
		
		if sanity > 100/200 then
			--we're pretty sane. clean up the monsters
			maxpop = 0
		elseif sanity > 20/200 then
			if GLOBAL.GetPlayer().prefab == "caitlin" then 
				--have up to three monsters when playing as Caitlin.
				maxpop = 3
				if self.currenttargetpop < 3 then
					inc_chance = .5
				else
					dec_chance = .1
				end
			else
				--have at most one monster, sometimes
				maxpop = 1
				if self.currenttargetpop == 0 then
					inc_chance = .3
				else
					dec_chance = .1
				end
			end
		else
			if GLOBAL.GetPlayer().prefab == "caitlin" then 
				--have up to 5 monsters
				maxpop = 5
				if self.currenttargetpop == 0 then
					inc_chance = .5
				elseif self.currenttargetpop == 5 then
					dec_chance = .2
				else
					inc_chance = .5
					dec_chance = .1
				end
			else
				--have at most one or two monsters, usually 1
				maxpop = 2
				if self.currenttargetpop == 0 then
					inc_chance = .3
				elseif self.currenttargetpop == 2 then
					dec_chance = .2
				else
					inc_chance = .2
					dec_chance = .2
				end
			end
		end
		
		--figure out our new target
		if self.currenttargetpop > maxpop then
			self.currenttargetpop = self.currenttargetpop - 1
		else
			if inc_chance > 0 and math.random() < inc_chance then
				self.currenttargetpop = self.currenttargetpop + 1
			elseif dec_chance > 0 and math.random() < dec_chance then
				self.currenttargetpop = self.currenttargetpop - 1
			end
		end
	end
	
	if self.spawntimer and self.spawntimer > 0 then
		self.spawntimer	= self.spawntimer - dt
	end
	
	
	if self.currenttargetpop > self.currentpop and (not self.spawntimer or self.spawntimer <= 0) then
		
		local pt = self:FindSpawnPoint()	
		if pt and GLOBAL.GetMap():GetTileAtPoint(pt:Get()) ~= GLOBAL.GROUND.IMPASSABLE then
			local prefab = "crawlinghorror"
			if sanity < 20/200 and math.random() < .5 then
				prefab = "terrorbeak"
			end
			self:AddMonsterOfType(prefab,pt)
		end
		
	elseif self.currenttargetpop < self.currentpop then
		self:RemoveRandomMonster()
	end
	end

end

AddComponentPostInit("sanitymonsterspawner", sanitymonsterspawnerpostinit)